<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

return new class extends Migration
{
    /**
     * Run the migrations.
     */
    public function up(): void
    {
        Schema::create('error_logs', function (Blueprint $table) {
            $table->id();
            $table->string('level')->default('error'); // error, warning, critical
            $table->string('type')->nullable(); // Exception class name
            $table->text('message');
            $table->text('file')->nullable();
            $table->integer('line')->nullable();
            $table->longText('trace')->nullable();
            $table->string('url')->nullable();
            $table->string('method')->nullable(); // GET, POST, etc
            $table->ipAddress('ip')->nullable();
            $table->string('user_agent')->nullable();
            $table->foreignId('user_id')->nullable()->constrained()->nullOnDelete();
            $table->json('context')->nullable(); // Additional context data
            $table->boolean('is_resolved')->default(false);
            $table->boolean('is_sent')->default(false); // Sent to support dashboard
            $table->timestamp('sent_at')->nullable();
            $table->timestamps();
            
            $table->index(['level', 'created_at']);
            $table->index(['is_resolved', 'created_at']);
            $table->index('user_id');
        });
    }

    /**
     * Reverse the migrations.
     */
    public function down(): void
    {
        Schema::dropIfExists('error_logs');
    }
};